
//
// This will load a set of ini file variables into the games variables for
// changing the settings between levels.
//
#include "g_local.h"

// Variables and defines go here.

int			test1		= false; 	// 
int			test2		= 100;		// 
int			defaultgravity = 800;
//
// Level ini file parameters.
//
typedef struct
{
	char	*ident;				// Name of the variable in the ini file 
	int		*variable;			// Pointer to the game variable
	int		MinVariable;		//
	int		MaxVariable;		// I think these are a bit obvious don't you
	int		DefaultVariable;	//
} 

LEVEL_INI_OPTION;

LEVEL_INI_OPTION	LevelSettings[] = 

//	Noraml options go here just incase something gets screwed up

	{	{"test1",		&test1,	0,1,1},
		{"test2",		&test2,	6,100,10}


	};

#define MAX_LEVEL_OPTIONS (sizeof(LevelSettings)/sizeof(LevelSettings[0]))

/***********************************************************************
/*
/*	Function:	Loads all the game settings.
/*
/*	Parameters:	None
/*
/**********************************************************************/
void LoadLevelSettings( char *LevelName )
	{	
	FILE	*f;
	cvar_t	*game_dir;
	int		IniOption = 0, Processed = 0;
	char	Buffer[256], Filename[256], FullPathname[256];
	char	*VariableName = NULL, *VariableValue = NULL;
	

	usedefault = 0;
	// Build up the filename for whatever level we are on. Doing it
	// this way people can configure any level known or unknown at
	// this time.
	strcpy( Filename, LevelName );
	strcat( Filename, ".ini" );

	game_dir = gi.cvar ("game", "", 0);

    sprintf(FullPathname, ".\\%s\\%s", game_dir->string, Filename);

	// open the *.ini file

	if ((f = fopen (FullPathname, "r")) == NULL)
		{
		gi.dprintf("Unable to read %s. Using defaults.\n", LevelName);
		usedefault=1;
		return;
		}
	
	gi.dprintf("\nProcessing %s settings\n", LevelName);

	// read 256 characters or until we get to the eof or a return for a newline.

	while (fgets(Buffer, sizeof(Buffer), f) != NULL)
		{
		// Ignore this line if it starts with a #, newline, space or [ bracket.

		if (Buffer[0] != '\t' && Buffer[0] != ' ' && Buffer[0] != '\n' && Buffer[0] != '#' && Buffer[0] != '[')
			{

			// Get the variable name, skipping spaces, tabs, and newlines.

			VariableName	= strtok(Buffer, " \t\n");
			IniOption	= 0;

			// If we haven't processed the maximum number of options then keep going
			while (IniOption < MAX_LEVEL_OPTIONS)
				{

				// Find this option in the array of options, if we don't find it tough

				if (!strcmp(VariableName, LevelSettings[IniOption].ident))
					{

					// Using NULL will continue the search for the value from where the previous
					// strtok for the variable name left off.
					VariableValue = strtok(NULL, " \t\n#");

					// This will set the value in the array using string value to integer conversion
					*LevelSettings[IniOption].variable = atoi(VariableValue);

					Processed++;
					break;
					}

				IniOption++;
				}
			}
		}

	gi.dprintf("%d Level settings processed\n", Processed);
	fclose (f);
	}

/***********************************************************************
/*
/*	Function:	Loads all the game settings.
/*
/*	Parameters:	None
/*
/**********************************************************************/
void VerifyLevelIniValues( void )
	{	
	int	Loop;

	for ( Loop=0; Loop<MAX_LEVEL_OPTIONS; Loop++ )
		{

		// If the value which has been set isn't in the normal range then
		// set it to a default value.


		if ((*LevelSettings[Loop].variable < LevelSettings[Loop].MinVariable) ||
			(*LevelSettings[Loop].variable > LevelSettings[Loop].MaxVariable))
			{
			*LevelSettings[Loop].variable = LevelSettings[Loop].DefaultVariable;
			}
		}
	}
